#include <bits/stdc++.h>

using namespace std;

#define int long long

const double eps = 1e-7;

struct point {
    double x, y;
};

point operator-(const point &a, const point &b) {
    return {a.x - b.x, a.y - b.y};
}

point operator+(const point &a, const point &b) {
    return {a.x + b.x, a.y + b.y};
}

point operator*(const point &a, const double &b) {
    return {a.x * b, a.y * b};
}

struct line {
    point a, n;

    line(point x, point y) {
        a = x;
        n = y - x;
    }
};

double cross(const point &a, const point &b) {
    return a.x * b.y - a.y * b.x;
}

vector<int> par, ran;

int find(int v) {
    if (v == par[v]) return v;
    return par[v] = find(par[v]);
}

void un(int a, int b) {
    a = find(a);
    b = find(b);
    if (a == b) return;
    if (ran[a] < ran[b]) swap(a, b);
    par[b] = a;
    if (ran[a] == ran[b]) ran[a]++;
}

point inter(const line &a1, const line &a2) {
//    if (cross(a1.n, a2.n) == 0 && ) return {13333, -3244454};
    double k = (cross(a2.a - a1.a, a2.n)) / (cross(a1.n, a2.n));
    return a1.a + a1.n * k;
}

bool on(const pair<point, point> &a, const point &k) {
    double x1, x2, y1, y2;
    x1 = min(a.first.x, a.second.x);
    x2 = max(a.first.x, a.second.x);
    y1 = min(a.first.y, a.second.y);
    y2 = max(a.first.y, a.second.y);

    if (k.x >= x1 - eps && k.x <= x2 + eps && k.y >= y1 - eps && k.y <= y2 + eps) return 1;
    return 0;
}

bool operator==(point a, point b) {
    return a.x == b.x && a.y == b.y;
}

bool is(pair<point, point> &a, pair<point, point> &b) {
    if (a.first == b.first || a.second == b.first || a.first == b.second || a.second == b.second) return 1;
    line x(a.first, a.second);
    line y(b.first, b.second);
    point t = inter(x, y);
//    if (t.x == 13333 && t.y == -3244454) return 0;
    if (on(a, t) && on(b, t)) return 1;
    return 0;
}

//mt19937 rnd(8);

signed main() {
    ios::sync_with_stdio(0);
    cin.tie(0);
    int _;
    cin >> _;
    while (_--) {
        int n = 4000;
        cin >> n;
        par.clear();
        for (int i = 0; i < n; i++) par.push_back(i);
        ran.assign(n, 0);
        int ans = 0;
        vector<pair<point, point>> w;
        for (int i = 0; i < n; i++) {
            double x, y, x1, y1;
            cin >> x >> y >> x1 >> y1;
            w.push_back({{x,  y},
                         {x1, y1}});
            vector<int> ma(n, 0);
            for (int j = 0; j < i; j++) {
                if (is(w[i], w[j])) {
                    ma[find(j)]++;
                }
            }
            for (int j = 0; j < n; j++) {
                if (ma[j] == 0) continue;
                ans += ma[j] - 1;
                un(i, j);
            }
        }
        cout << ans + 1 << '\n';
    }
}
